/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.LongBlockPos;
import qouteall.q_misc_util.my_util.RayTraceResult;

public class Helper {
    public static final Logger LOGGER = LogManager.getLogger((String)"iPortal");
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();

    public static double getCollidingT(class_243 planeCenter, class_243 planeNormal, class_243 lineOrigin, class_243 lineDirection) {
        return planeCenter.method_1020(lineOrigin).method_1026(planeNormal) / lineDirection.method_1026(planeNormal);
    }

    public static double getCollidingT(double planeOriginX, double planeOriginY, double planeOriginZ, double planeNormalX, double planeNormalY, double planeNormalZ, double lineOriginX, double lineOriginY, double lineOriginZ, double lineDeltaX, double lineDeltaY, double lineDeltaZ) {
        double denom = lineDeltaX * planeNormalX + lineDeltaY * planeNormalY + lineDeltaZ * planeNormalZ;
        if (Math.abs(denom) < 1.0E-6) {
            return Double.NaN;
        }
        return ((planeOriginX - lineOriginX) * planeNormalX + (planeOriginY - lineOriginY) * planeNormalY + (planeOriginZ - lineOriginZ) * planeNormalZ) / denom;
    }

    @Nullable
    public static RayTraceResult raytraceAABB(boolean boxFacingOutwards, double boxMinX, double boxMinY, double boxMinZ, double boxMaxX, double boxMaxY, double boxMaxZ, double lineOriginX, double lineOriginY, double lineOriginZ, double lineDeltaX, double lineDeltaY, double lineDeltaZ) {
        double tZ;
        double tY;
        boolean originInBox;
        boolean bl = originInBox = lineOriginX > boxMinX && lineOriginX < boxMaxX && lineOriginY > boxMinY && lineOriginY < boxMaxY && lineOriginZ > boxMinZ && lineOriginZ < boxMaxZ;
        if (boxFacingOutwards && originInBox) {
            return null;
        }
        boolean testXPosi = lineDeltaX > 0.0 ^ boxFacingOutwards;
        boolean testYPosi = lineDeltaY > 0.0 ^ boxFacingOutwards;
        boolean testZPosi = lineDeltaZ > 0.0 ^ boxFacingOutwards;
        boolean normalXPosi = lineDeltaX <= 0.0;
        boolean normalYPosi = lineDeltaY <= 0.0;
        boolean normalZPosi = lineDeltaZ <= 0.0;
        double tX = Helper.getCollidingT(testXPosi ? boxMaxX : boxMinX, 0.0, 0.0, normalXPosi ? 1.0 : -1.0, 0.0, 0.0, lineOriginX, lineOriginY, lineOriginZ, lineDeltaX, lineDeltaY, lineDeltaZ);
        if (!Double.isNaN(tX) && tX >= 0.0 && tX <= 1.0) {
            double y = lineOriginY + tX * lineDeltaY;
            double z = lineOriginZ + tX * lineDeltaZ;
            if (y >= boxMinY && y <= boxMaxY && z >= boxMinZ && z <= boxMaxZ) {
                return new RayTraceResult(tX, new class_243(testXPosi ? boxMaxX : boxMinX, y, z), new class_243(testXPosi ? 1.0 : -1.0, 0.0, 0.0));
            }
        }
        if (!Double.isNaN(tY = Helper.getCollidingT(0.0, testYPosi ? boxMaxY : boxMinY, 0.0, 0.0, normalYPosi ? 1.0 : -1.0, 0.0, lineOriginX, lineOriginY, lineOriginZ, lineDeltaX, lineDeltaY, lineDeltaZ)) && tY >= 0.0 && tY <= 1.0) {
            double x = lineOriginX + tY * lineDeltaX;
            double z = lineOriginZ + tY * lineDeltaZ;
            if (x >= boxMinX && x <= boxMaxX && z >= boxMinZ && z <= boxMaxZ) {
                return new RayTraceResult(tY, new class_243(x, testYPosi ? boxMaxY : boxMinY, z), new class_243(0.0, testYPosi ? 1.0 : -1.0, 0.0));
            }
        }
        if (!Double.isNaN(tZ = Helper.getCollidingT(0.0, 0.0, testZPosi ? boxMaxZ : boxMinZ, 0.0, 0.0, normalZPosi ? 1.0 : -1.0, lineOriginX, lineOriginY, lineOriginZ, lineDeltaX, lineDeltaY, lineDeltaZ)) && tZ >= 0.0 && tZ <= 1.0) {
            double x = lineOriginX + tZ * lineDeltaX;
            double y = lineOriginY + tZ * lineDeltaY;
            if (x >= boxMinX && x <= boxMaxX && y >= boxMinY && y <= boxMaxY) {
                return new RayTraceResult(tZ, new class_243(x, y, testZPosi ? boxMaxZ : boxMinZ), new class_243(0.0, 0.0, testZPosi ? 1.0 : -1.0));
            }
        }
        return null;
    }

    public static boolean isInFrontOfPlane(class_243 pos, class_243 planePos, class_243 planeNormal) {
        return pos.method_1020(planePos).method_1026(planeNormal) > 0.0;
    }

    public static class_243 fallPointOntoPlane(class_243 point, class_243 planePos, class_243 planeNormal) {
        double t = Helper.getCollidingT(planePos, planeNormal, point, planeNormal);
        return point.method_1019(planeNormal.method_1021(t));
    }

    public static class_2382 getUnitFromAxis(class_2350.class_2351 axis) {
        return class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis).method_10163();
    }

    public static int getCoordinate(class_2382 v, class_2350.class_2351 axis) {
        return axis.method_10173(v.method_10263(), v.method_10264(), v.method_10260());
    }

    public static double getCoordinate(class_243 v, class_2350.class_2351 axis) {
        return axis.method_10172(v.field_1352, v.field_1351, v.field_1350);
    }

    public static int getCoordinate(class_2382 v, class_2350 direction) {
        return Helper.getCoordinate(v, direction.method_10166()) * (direction.method_10171() == class_2350.class_2352.field_11056 ? 1 : -1);
    }

    public static class_243 putCoordinate(class_243 v, class_2350.class_2351 axis, double value) {
        return switch (axis) {
            case class_2350.class_2351.field_11048 -> new class_243(value, v.field_1351, v.field_1350);
            case class_2350.class_2351.field_11052 -> new class_243(v.field_1352, value, v.field_1350);
            default -> new class_243(v.field_1352, v.field_1351, value);
        };
    }

    public static class_2338 putCoordinate(class_2382 v, class_2350.class_2351 axis, int value) {
        return switch (axis) {
            case class_2350.class_2351.field_11048 -> new class_2338(value, v.method_10264(), v.method_10260());
            case class_2350.class_2351.field_11052 -> new class_2338(v.method_10263(), value, v.method_10260());
            default -> new class_2338(v.method_10263(), v.method_10264(), value);
        };
    }

    public static class_243 putSignedCoordinate(class_243 vec, class_2350 direction, double value) {
        return switch (direction) {
            case class_2350.field_11033 -> new class_243(vec.field_1352, -value, vec.field_1350);
            case class_2350.field_11036 -> new class_243(vec.field_1352, value, vec.field_1350);
            case class_2350.field_11043 -> new class_243(vec.field_1352, vec.field_1351, -value);
            case class_2350.field_11035 -> new class_243(vec.field_1352, vec.field_1351, value);
            case class_2350.field_11039 -> new class_243(-value, vec.field_1351, vec.field_1350);
            case class_2350.field_11034 -> new class_243(value, vec.field_1351, vec.field_1350);
            default -> throw new RuntimeException();
        };
    }

    public static double getSignedCoordinate(class_243 vec, class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11033 -> -vec.field_1351;
            case class_2350.field_11036 -> vec.field_1351;
            case class_2350.field_11043 -> -vec.field_1350;
            case class_2350.field_11035 -> vec.field_1350;
            case class_2350.field_11039 -> -vec.field_1352;
            case class_2350.field_11034 -> vec.field_1352;
            default -> throw new RuntimeException();
        };
    }

    public static double getDistanceSqrOnAxisPlane(class_243 vec, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> vec.field_1351 * vec.field_1351 + vec.field_1350 * vec.field_1350;
            case class_2350.class_2351.field_11052 -> vec.field_1352 * vec.field_1352 + vec.field_1350 * vec.field_1350;
            case class_2350.class_2351.field_11051 -> vec.field_1352 * vec.field_1352 + vec.field_1351 * vec.field_1351;
        };
    }

    public static double getBoxCoordinate(class_238 box, class_2350 direction) {
        switch (direction) {
            case field_11033: {
                return box.field_1322;
            }
            case field_11036: {
                return box.field_1325;
            }
            case field_11043: {
                return box.field_1321;
            }
            case field_11035: {
                return box.field_1324;
            }
            case field_11039: {
                return box.field_1323;
            }
            case field_11034: {
                return box.field_1320;
            }
        }
        throw new RuntimeException();
    }

    public static class_238 replaceBoxCoordinate(class_238 box, class_2350 direction, double coordinate) {
        switch (direction) {
            case field_11033: {
                return new class_238(box.field_1323, coordinate, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
            }
            case field_11036: {
                return new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, coordinate, box.field_1324);
            }
            case field_11043: {
                return new class_238(box.field_1323, box.field_1322, coordinate, box.field_1320, box.field_1325, box.field_1324);
            }
            case field_11035: {
                return new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, coordinate);
            }
            case field_11039: {
                return new class_238(coordinate, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
            }
            case field_11034: {
                return new class_238(box.field_1323, box.field_1322, box.field_1321, coordinate, box.field_1325, box.field_1324);
            }
        }
        throw new RuntimeException();
    }

    public static <A, B> class_3545<B, A> swaped(class_3545<A, B> p) {
        return new class_3545(p.method_15441(), p.method_15442());
    }

    public static <T> T uniqueOfThree(T a, T b, T c) {
        if (a.equals(b)) {
            return c;
        }
        if (b.equals(c)) {
            return a;
        }
        assert (a.equals(c));
        return b;
    }

    public static class_2338 max(class_2338 a, class_2338 b) {
        return new class_2338(Math.max(a.method_10263(), b.method_10263()), Math.max(a.method_10264(), b.method_10264()), Math.max(a.method_10260(), b.method_10260()));
    }

    public static class_2338 min(class_2338 a, class_2338 b) {
        return new class_2338(Math.min(a.method_10263(), b.method_10263()), Math.min(a.method_10264(), b.method_10264()), Math.min(a.method_10260(), b.method_10260()));
    }

    public static class_3545<class_2350.class_2351, class_2350.class_2351> getAnotherTwoAxis(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return new class_3545((Object)class_2350.class_2351.field_11052, (Object)class_2350.class_2351.field_11051);
            }
            case field_11052: {
                return new class_3545((Object)class_2350.class_2351.field_11051, (Object)class_2350.class_2351.field_11048);
            }
            case field_11051: {
                return new class_3545((Object)class_2350.class_2351.field_11048, (Object)class_2350.class_2351.field_11052);
            }
        }
        throw new IllegalArgumentException();
    }

    public static class_2338 scale(class_2382 v, int m) {
        return new class_2338(v.method_10263() * m, v.method_10264() * m, v.method_10260() * m);
    }

    public static class_2338 divide(class_2382 v, int d) {
        return new class_2338(v.method_10263() / d, v.method_10264() / d, v.method_10260() / d);
    }

    public static class_2338 floorDiv(class_2382 v, int d) {
        return new class_2338(Math.floorDiv(v.method_10263(), d), Math.floorDiv(v.method_10264(), d), Math.floorDiv(v.method_10260(), d));
    }

    public static class_2350[] getAnotherFourDirections(class_2350.class_2351 axisOfNormal) {
        class_3545<class_2350.class_2351, class_2350.class_2351> anotherTwoAxis = Helper.getAnotherTwoAxis(axisOfNormal);
        return new class_2350[]{class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)anotherTwoAxis.method_15442())), class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)anotherTwoAxis.method_15441())), class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)((class_2350.class_2351)anotherTwoAxis.method_15442())), class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)((class_2350.class_2351)anotherTwoAxis.method_15441()))};
    }

    public static class_3545<class_2350, class_2350> getPerpendicularDirections(class_2350 facing) {
        class_3545 axises = Helper.getAnotherTwoAxis(facing.method_10166());
        if (facing.method_10171() == class_2350.class_2352.field_11060) {
            axises = new class_3545((Object)((class_2350.class_2351)axises.method_15441()), (Object)((class_2350.class_2351)axises.method_15442()));
        }
        return new class_3545((Object)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)axises.method_15442())), (Object)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)((class_2350.class_2351)axises.method_15441())));
    }

    public static class_243 getBoxSize(class_238 box) {
        return new class_243(box.method_17939(), box.method_17940(), box.method_17941());
    }

    public static class_238 getBoxSurfaceInversed(class_238 box, class_2350 direction) {
        double size = Helper.getCoordinate(Helper.getBoxSize(box), direction.method_10166());
        class_243 shrinkVec = class_243.method_24954((class_2382)direction.method_10163()).method_1021(size);
        return box.method_1002(shrinkVec.field_1352, shrinkVec.field_1351, shrinkVec.field_1350);
    }

    public static class_238 getBoxSurface(class_238 box, class_2350 direction) {
        return Helper.getBoxSurfaceInversed(box, direction.method_10153());
    }

    public static IntBox expandRectangle(class_2338 startingPos, Predicate<class_2338> blockPosPredicate, class_2350.class_2351 axis) {
        IntBox wallArea = new IntBox(startingPos, startingPos);
        for (class_2350 direction : Helper.getAnotherFourDirections(axis)) {
            wallArea = Helper.expandArea(wallArea, blockPosPredicate, direction);
        }
        return wallArea;
    }

    public static IntBox expandBoxArea(class_2338 startingPos, Predicate<class_2338> blockPosPredicate) {
        IntBox box = new IntBox(startingPos, startingPos);
        for (class_2350 direction : class_2350.values()) {
            box = Helper.expandArea(box, blockPosPredicate, direction);
        }
        return box;
    }

    public static int getChebyshevDistance(int x1, int z1, int x2, int z2) {
        return Math.max(Math.abs(x1 - x2), Math.abs(z1 - z2));
    }

    public static class_238 getBoxByBottomPosAndSize(class_243 boxBottomCenter, class_243 viewBoxSize) {
        return new class_238(boxBottomCenter.method_1023(viewBoxSize.field_1352 / 2.0, 0.0, viewBoxSize.field_1350 / 2.0), boxBottomCenter.method_1031(viewBoxSize.field_1352 / 2.0, viewBoxSize.field_1351, viewBoxSize.field_1350 / 2.0));
    }

    public static class_243 getBoxBottomCenter(class_238 box) {
        return new class_243((box.field_1320 + box.field_1323) / 2.0, box.field_1322, (box.field_1324 + box.field_1321) / 2.0);
    }

    public static double getDistanceToRectangle(double pointX, double pointY, double rectAX, double rectAY, double rectBX, double rectBY) {
        assert (rectAX <= rectBX);
        assert (rectAY <= rectBY);
        double wx1 = rectAX - pointX;
        double wx2 = rectBX - pointX;
        double dx = wx1 * wx2 < 0.0 ? 0.0 : Math.min(Math.abs(wx1), Math.abs(wx2));
        double wy1 = rectAY - pointY;
        double wy2 = rectBY - pointY;
        double dy = wy1 * wy2 < 0.0 ? 0.0 : Math.min(Math.abs(wy1), Math.abs(wy2));
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static <T> void swapListElement(List<T> entries, int i1, int i2) {
        T temp = entries.get(i1);
        entries.set(i1, entries.get(i2));
        entries.set(i2, temp);
    }

    public static double crossProduct2D(double x1, double y1, double x2, double y2) {
        return x1 * y2 - x2 * y1;
    }

    public static class_5321<class_1937> dimIdToKey(class_2960 identifier) {
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)identifier);
    }

    public static class_5321<class_1937> dimIdToKey(String str) {
        return Helper.dimIdToKey(McHelper.newResourceLocation(str));
    }

    public static void putWorldId(class_2487 tag, String tagName, class_5321<class_1937> dim) {
        tag.method_10582(tagName, dim.method_29177().toString());
    }

    public static class_5321<class_1937> getWorldId(class_2487 tag, String tagName) {
        class_2520 term = tag.method_10580(tagName);
        if (term instanceof class_2519) {
            String id = ((class_2519)term).method_10714();
            return Helper.dimIdToKey(id);
        }
        LOGGER.error("Cannot read world id from {}. Fallback to overworld", (Object)tag);
        return class_1937.field_25179;
    }

    @Nullable
    public static <T> T getLastSatisfying(Stream<T> stream, Predicate<T> predicate) {
        T last = null;
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (predicate.test(obj)) {
                last = obj;
                continue;
            }
            return last;
        }
        return last;
    }

    public static void doNotEatExceptionMessage(Runnable func) {
        try {
            func.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static <T> String myToString(Stream<T> stream) {
        StringBuilder stringBuilder = new StringBuilder();
        stream.forEach(obj -> {
            stringBuilder.append(obj.toString());
            stringBuilder.append('\n');
        });
        return stringBuilder.toString();
    }

    public static <A, B> Stream<class_3545<A, B>> composeTwoStreamsWithEqualLength(Stream<A> a, Stream<B> b) {
        final Iterator aIterator = a.iterator();
        final Iterator bIterator = b.iterator();
        Iterator iterator = new Iterator<class_3545<A, B>>(){

            @Override
            public boolean hasNext() {
                assert (aIterator.hasNext() == bIterator.hasNext());
                return aIterator.hasNext();
            }

            @Override
            public class_3545<A, B> next() {
                return new class_3545(aIterator.next(), bIterator.next());
            }
        };
        return Streams.stream((Iterator)iterator);
    }

    @Deprecated
    public static void log(Object str) {
        LOGGER.info(str);
    }

    @Deprecated
    public static void err(Object str) {
        LOGGER.error(str);
    }

    public static class_243[] eightVerticesOf(class_238 box) {
        return new class_243[]{new class_243(box.field_1323, box.field_1322, box.field_1321), new class_243(box.field_1323, box.field_1322, box.field_1324), new class_243(box.field_1323, box.field_1325, box.field_1321), new class_243(box.field_1323, box.field_1325, box.field_1324), new class_243(box.field_1320, box.field_1322, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1324), new class_243(box.field_1320, box.field_1325, box.field_1321), new class_243(box.field_1320, box.field_1325, box.field_1324)};
    }

    public static void putVec3d(class_2487 compoundTag, String name, class_243 vec3d) {
        compoundTag.method_10549(name + "X", vec3d.field_1352);
        compoundTag.method_10549(name + "Y", vec3d.field_1351);
        compoundTag.method_10549(name + "Z", vec3d.field_1350);
    }

    public static class_243 getVec3d(class_2487 compoundTag, String name) {
        return new class_243(compoundTag.method_10574(name + "X"), compoundTag.method_10574(name + "Y"), compoundTag.method_10574(name + "Z"));
    }

    @Nullable
    public static class_243 getVec3dOptional(class_2487 compoundTag, String name) {
        if (compoundTag.method_10545(name + "X")) {
            return Helper.getVec3d(compoundTag, name);
        }
        return null;
    }

    public static void putVec3i(class_2487 compoundTag, String name, class_2382 vec3i) {
        compoundTag.method_10569(name + "X", vec3i.method_10263());
        compoundTag.method_10569(name + "Y", vec3i.method_10264());
        compoundTag.method_10569(name + "Z", vec3i.method_10260());
    }

    public static class_2338 getVec3i(class_2487 compoundTag, String name) {
        return new class_2338(compoundTag.method_10550(name + "X"), compoundTag.method_10550(name + "Y"), compoundTag.method_10550(name + "Z"));
    }

    public static void putQuaternion(class_2487 compoundTag, String name, @Nullable DQuaternion quaternion) {
        if (quaternion != null) {
            compoundTag.method_10549(name + "X", quaternion.getX());
            compoundTag.method_10549(name + "Y", quaternion.getY());
            compoundTag.method_10549(name + "Z", quaternion.getZ());
            compoundTag.method_10549(name + "W", quaternion.getW());
        }
    }

    @Nullable
    public static DQuaternion getQuaternion(class_2487 compoundTag, String name) {
        if (compoundTag.method_10545(name + "X")) {
            return new DQuaternion(compoundTag.method_10574(name + "X"), compoundTag.method_10574(name + "Y"), compoundTag.method_10574(name + "Z"), compoundTag.method_10574(name + "W"));
        }
        return null;
    }

    public static class_2499 getCompoundList(class_2487 tag, String name) {
        return tag.method_10554(name, 10);
    }

    public static <X> ArrayList<X> listTagToList(class_2499 listTag, Function<class_2487, X> deserializer) {
        return Helper.listTagDeserialize(listTag, deserializer, class_2487.class);
    }

    public static <X> class_2499 listToListTag(List<X> list, Function<X, class_2487> serializer) {
        return Helper.listTagSerialize(list, serializer);
    }

    public static <X, TT extends class_2520> ArrayList<X> listTagDeserialize(class_2499 listTag, Function<TT, X> deserializer, Class<TT> tagClass) {
        ArrayList result = new ArrayList();
        listTag.forEach(tag -> {
            if (tag.getClass() == tagClass) {
                Object obj = deserializer.apply(tag);
                if (obj != null) {
                    result.add(obj);
                }
            } else {
                LOGGER.error("Unexpected tag class: {}", (Object)tag.getClass(), (Object)new Throwable());
            }
        });
        return result;
    }

    public static <X, TT extends class_2520> class_2499 listTagSerialize(List<X> list, Function<X, TT> serializer) {
        class_2499 listTag = new class_2499();
        for (X x : list) {
            listTag.add((Object)((class_2520)serializer.apply(x)));
        }
        return listTag;
    }

    public static <T> void compareOldAndNew(Set<T> oldSet, Set<T> newSet, Consumer<T> forRemoved, Consumer<T> forAdded) {
        oldSet.stream().filter(e -> !newSet.contains(e)).forEach(forRemoved);
        newSet.stream().filter(e -> !oldSet.contains(e)).forEach(forAdded);
    }

    public static long secondToNano(double second) {
        return (long)(second * 1.0E9);
    }

    public static double nanoToSecond(long nano) {
        return (double)nano / 1.0E9;
    }

    public static IntBox expandArea(IntBox originalArea, Predicate<class_2338> predicate, class_2350 direction) {
        IntBox currentBox = originalArea;
        for (int i = 1; i < 42; ++i) {
            IntBox expanded = currentBox.getExpanded(direction, 1);
            if (!expanded.getSurfaceLayer(direction).stream().allMatch(predicate)) {
                return currentBox;
            }
            currentBox = expanded;
        }
        return currentBox;
    }

    public static <A, B> B reduce(B start, Stream<A> stream, BiFunction<B, A, B> func) {
        return stream.reduce(start, func, (a, b) -> {
            throw new IllegalStateException("combiner should only be used in parallel");
        });
    }

    public static <T> T noError(Callable<T> func) {
        try {
            return func.call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> void removeIf(ObjectList<T> list, Predicate<T> predicate) {
        int placingIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object curr = list.get(i);
            if (predicate.test(curr)) continue;
            list.set(placingIndex, curr);
            ++placingIndex;
        }
        list.removeElements(placingIndex, list.size());
    }

    public static <T> void removeIfWithEarlyExit(ObjectList<T> list, BiPredicate<T, MutableBoolean> predicate) {
        MutableBoolean shouldStop = new MutableBoolean(false);
        int placingIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object curr = list.get(i);
            if (!shouldStop.booleanValue() && predicate.test(curr, shouldStop)) continue;
            list.set(placingIndex, curr);
            ++placingIndex;
        }
        list.removeElements(placingIndex, list.size());
    }

    public static <T, S> Stream<S> wrapAdjacentAndMap(Stream<T> stream, final BiFunction<T, T, S> function) {
        final Iterator iterator = stream.iterator();
        return Streams.stream((Iterator)new Iterator<S>(){
            private boolean isBuffered = false;
            private T buffer;

            private void fillBuffer() {
                if (!this.isBuffered) {
                    assert (iterator.hasNext());
                    this.isBuffered = true;
                    this.buffer = iterator.next();
                }
            }

            private T takeBuffer() {
                assert (this.isBuffered);
                this.isBuffered = false;
                return this.buffer;
            }

            @Override
            public boolean hasNext() {
                if (!iterator.hasNext()) {
                    return false;
                }
                this.fillBuffer();
                return iterator.hasNext();
            }

            @Override
            public S next() {
                this.fillBuffer();
                Object a = this.takeBuffer();
                this.fillBuffer();
                return function.apply(a, this.buffer);
            }
        });
    }

    public static <A, B> Stream<B> mapReduce(Stream<A> stream, BiFunction<B, A, B> func, SimpleBox<B> startValue) {
        return stream.map(a -> {
            startValue.obj = func.apply(startValue.obj, a);
            return startValue.obj;
        });
    }

    public static <T, S> Stream<S> wrapAdjacentAndMap1(Stream<T> stream, BiFunction<T, T, S> function) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return Stream.empty();
        }
        Object firstValue = iterator.next();
        Stream newStream = Streams.stream(iterator);
        return Helper.mapReduce(newStream, (lastPair, curr) -> new class_3545(curr, function.apply(lastPair.method_15442(), curr)), new SimpleBox<class_3545>(new class_3545(firstValue, null))).map(pair -> pair.method_15441());
    }

    public static <T> T makeIntoExpression(T t, Consumer<T> func) {
        func.accept(t);
        return t;
    }

    public static void putUuid(class_2487 tag, String key, UUID uuid) {
        tag.method_10544(key + "Most", uuid.getMostSignificantBits());
        tag.method_10544(key + "Least", uuid.getLeastSignificantBits());
    }

    @Nullable
    public static UUID getUuid(class_2487 tag, String key) {
        String key1 = key + "Most";
        if (!tag.method_10545(key1)) {
            return null;
        }
        return new UUID(tag.method_10537(key1), tag.method_10537(key + "Least"));
    }

    public static class_243 getFlippedVec(class_243 vec, class_243 flippingAxis) {
        class_243 component = Helper.getProjection(vec, flippingAxis);
        return vec.method_1020(component).method_1021(-1.0).method_1019(component);
    }

    public static class_243 getProjection(class_243 vec, class_243 direction) {
        return direction.method_1021(vec.method_1026(direction));
    }

    public static class_2350 getFacingExcludingAxis(class_243 vec, class_2350.class_2351 axis) {
        return Arrays.stream(class_2350.values()).filter(d -> d.method_10166() != axis).max(Comparator.comparingDouble(dir -> vec.field_1352 * (double)dir.method_10148() + vec.field_1351 * (double)dir.method_10164() + vec.field_1350 * (double)dir.method_10165())).orElse(null);
    }

    public static <T> Supplier<T> cached(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T cache = null;

            @Override
            public T get() {
                if (this.cache == null) {
                    this.cache = supplier.get();
                }
                Validate.notNull(this.cache);
                return this.cache;
            }
        };
    }

    public static <T> int indexOf(List<T> list, Predicate<T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            T ele = list.get(i);
            if (!predicate.test(ele)) continue;
            return i;
        }
        return -1;
    }

    public static List<String> splitStringByLen(String str, int len) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i * len < str.length()) {
            result.add(str.substring(i * len, Math.min(str.length(), (i + 1) * len)));
            ++i;
        }
        return result;
    }

    public static class_238 transformBox(class_238 box, Function<class_243, class_243> function) {
        List result = Arrays.stream(Helper.eightVerticesOf(box)).map(function).collect(Collectors.toList());
        return new class_238(result.stream().mapToDouble(b -> b.field_1352).min().getAsDouble(), result.stream().mapToDouble(b -> b.field_1351).min().getAsDouble(), result.stream().mapToDouble(b -> b.field_1350).min().getAsDouble(), result.stream().mapToDouble(b -> b.field_1352).max().getAsDouble(), result.stream().mapToDouble(b -> b.field_1351).max().getAsDouble(), result.stream().mapToDouble(b -> b.field_1350).max().getAsDouble());
    }

    public static double getDistanceToRange(double start, double end, double pos) {
        Validate.isTrue((end >= start ? 1 : 0) != 0);
        if (pos >= start) {
            if (pos <= end) {
                return 0.0;
            }
            return pos - end;
        }
        return start - pos;
    }

    public static double getSignedDistanceToRange(double start, double end, double pos) {
        Validate.isTrue((end >= start ? 1 : 0) != 0);
        if (pos >= start) {
            if (pos <= end) {
                return -Math.min(pos - start, end - pos);
            }
            return pos - end;
        }
        return start - pos;
    }

    public static double getDistanceToBox(class_238 box, class_243 point) {
        double dx = Helper.getDistanceToRange(box.field_1323, box.field_1320, point.field_1352);
        double dy = Helper.getDistanceToRange(box.field_1322, box.field_1325, point.field_1351);
        double dz = Helper.getDistanceToRange(box.field_1321, box.field_1324, point.field_1350);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getSignedDistanceToBox(class_238 aabb, class_243 point) {
        double dx = Helper.getSignedDistanceToRange(aabb.field_1323, aabb.field_1320, point.field_1352);
        double dy = Helper.getSignedDistanceToRange(aabb.field_1322, aabb.field_1325, point.field_1351);
        double dz = Helper.getSignedDistanceToRange(aabb.field_1321, aabb.field_1324, point.field_1350);
        double l = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dx < 0.0 && dy < 0.0 && dz < 0.0) {
            return -l;
        }
        return l;
    }

    public static <T> T firstOf(List<T> list) {
        Validate.isTrue((!list.isEmpty() ? 1 : 0) != 0);
        return list.get(0);
    }

    public static <T> T lastOf(List<T> list) {
        Validate.isTrue((!list.isEmpty() ? 1 : 0) != 0);
        return list.get(list.size() - 1);
    }

    @Nullable
    public static <T> T combineNullable(@Nullable T a, @Nullable T b, BiFunction<T, T, T> combiner) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return combiner.apply(a, b);
    }

    public static <T> T arrayListComputeIfAbsent(List<T> arrayList, int index, Supplier<T> supplier) {
        T value;
        if (arrayList.size() <= index) {
            while (arrayList.size() <= index) {
                arrayList.add(null);
            }
        }
        if ((value = arrayList.get(index)) == null) {
            value = supplier.get();
            arrayList.set(index, value);
        }
        return value;
    }

    public static <T> void arrayListKeyValueForeach(ArrayList<T> arrayList, IntObjectConsumer<T> func) {
        for (int i = 0; i < arrayList.size(); ++i) {
            T value = arrayList.get(i);
            if (value == null) continue;
            func.consume(i, value);
        }
    }

    public static Object reflectionInvoke(Object target, String methodName) {
        return Helper.noError(() -> {
            Method method = target.getClass().getDeclaredMethod(methodName, new Class[0]);
            return method.invoke(target, new Object[0]);
        });
    }

    public static class_243 interpolatePos(class_243 from, class_243 to, double progress) {
        return from.method_35590(to, progress);
    }

    public static <T> T getFirstNullable(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T minBy(T a, T b, Comparator<T> comparator) {
        if (comparator.compare(a, b) <= 0) {
            return a;
        }
        return b;
    }

    public static <T> T maxBy(T a, T b, Comparator<T> comparator) {
        if (comparator.compare(a, b) >= 0) {
            return a;
        }
        return b;
    }

    public static boolean boxContains(class_238 outer, class_238 inner) {
        return outer.method_1008(inner.field_1323, inner.field_1322, inner.field_1321) && outer.method_1008(inner.field_1320, inner.field_1325, inner.field_1324);
    }

    public static <A, B> List<B> mappedListView(final List<A> originalList, final Function<A, B> mapping) {
        return new AbstractList<B>(){

            @Override
            public B get(int index) {
                return mapping.apply(originalList.get(index));
            }

            @Override
            public int size() {
                return originalList.size();
            }
        };
    }

    public static OptionalDouble parseDouble(String str) {
        try {
            return OptionalDouble.of(Double.parseDouble(str));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    public static OptionalInt parseInt(String str) {
        try {
            return OptionalInt.of(Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public static List<class_243> deduplicateWithPrecision(Collection<class_243> points, int precision) {
        HashSet<LongBlockPos> set = new HashSet<LongBlockPos>();
        for (class_243 point : points) {
            set.add(new LongBlockPos(Math.round(point.field_1352 * (double)precision), Math.round(point.field_1351 * (double)precision), Math.round(point.field_1350 * (double)precision)));
        }
        return set.stream().map(blockPos -> new class_243((double)blockPos.x() / (double)precision, (double)blockPos.y() / (double)precision, (double)blockPos.z() / (double)precision)).collect(Collectors.toList());
    }

    public static double getDistanceFromPointToLine(class_243 point, class_243 lineOrigin, class_243 lineDirection) {
        class_243 lineDirectionNormalized = lineDirection.method_1029();
        class_243 pointToLineOrigin = lineOrigin.method_1020(point);
        class_243 pointToLineOriginProjected = pointToLineOrigin.method_1020(lineDirectionNormalized.method_1021(pointToLineOrigin.method_1026(lineDirectionNormalized)));
        return pointToLineOriginProjected.method_1033();
    }

    public static void traverseBoxEdge(BoxEdgeConsumer consumer) {
        int dz;
        int dx;
        for (dx = 0; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                consumer.consume(dx, dy, 0, dx, dy, 1);
            }
        }
        for (dx = 0; dx <= 1; ++dx) {
            for (dz = 0; dz <= 1; ++dz) {
                consumer.consume(dx, 0, dz, dx, 1, dz);
            }
        }
        for (int dy = 0; dy <= 1; ++dy) {
            for (dz = 0; dz <= 1; ++dz) {
                consumer.consume(0, dy, dz, 1, dy, dz);
            }
        }
    }

    public static List<class_243> verticesAndEdgeMidpoints(class_238 box) {
        ArrayList<class_243> result = new ArrayList<class_243>();
        for (int xi = 0; xi <= 2; ++xi) {
            for (int yi = 0; yi <= 2; ++yi) {
                for (int zi = 0; zi <= 2; ++zi) {
                    if (xi == 1 && yi == 1 && zi == 1) continue;
                    double x = box.field_1323 + (double)xi / 2.0 * (box.field_1320 - box.field_1323);
                    double y = box.field_1322 + (double)yi / 2.0 * (box.field_1325 - box.field_1322);
                    double z = box.field_1321 + (double)zi / 2.0 * (box.field_1324 - box.field_1321);
                    result.add(new class_243(x, y, z));
                }
            }
        }
        return result;
    }

    public static class_243 alignToBoxSurface(class_238 box, class_243 pos, int gridCount) {
        double x = pos.field_1352;
        double y = pos.field_1351;
        double z = pos.field_1350;
        if (x < box.field_1323) {
            x = box.field_1323;
        }
        if (y < box.field_1322) {
            y = box.field_1322;
        }
        if (z < box.field_1321) {
            z = box.field_1321;
        }
        if (x > box.field_1320) {
            x = box.field_1320;
        }
        if (y > box.field_1325) {
            y = box.field_1325;
        }
        if (z > box.field_1324) {
            z = box.field_1324;
        }
        double boxSizeX = box.method_17939();
        double boxSizeY = box.method_17940();
        double boxSizeZ = box.method_17941();
        double xOffset = x - box.field_1323;
        double yOffset = y - box.field_1322;
        double zOffset = z - box.field_1321;
        xOffset = (double)Math.round(xOffset * (double)gridCount) / (double)gridCount;
        yOffset = (double)Math.round(yOffset * (double)gridCount) / (double)gridCount;
        zOffset = (double)Math.round(zOffset * (double)gridCount) / (double)gridCount;
        double distanceToXMin = xOffset;
        double distanceToXMax = boxSizeX - xOffset;
        double distanceToYMin = yOffset;
        double distanceToYMax = boxSizeY - yOffset;
        double distanceToZMin = zOffset;
        double distanceToZMax = boxSizeZ - zOffset;
        double minDistance = Math.min(Math.min(distanceToXMin, distanceToXMax), Math.min(Math.min(distanceToYMin, distanceToYMax), Math.min(distanceToZMin, distanceToZMax)));
        if (minDistance == distanceToXMin) {
            xOffset = 0.0;
        } else if (minDistance == distanceToXMax) {
            xOffset = boxSizeX;
        } else if (minDistance == distanceToYMin) {
            yOffset = 0.0;
        } else if (minDistance == distanceToYMax) {
            yOffset = boxSizeY;
        } else if (minDistance == distanceToZMin) {
            zOffset = 0.0;
        } else if (minDistance == distanceToZMax) {
            zOffset = boxSizeZ;
        }
        return new class_243(box.field_1323 + xOffset, box.field_1322 + yOffset, box.field_1321 + zOffset);
    }

    public static int compactArrayStorage(int arraySize, IntPredicate isElementValid, SwappingFunc swap) {
        int validElementCount = 0;
        int invalidElementCount = 0;
        block0: while (validElementCount + invalidElementCount < arraySize) {
            if (isElementValid.test(validElementCount)) {
                ++validElementCount;
                continue;
            }
            int invalidElementIndex = arraySize - ++invalidElementCount;
            while (invalidElementIndex > validElementCount) {
                if (isElementValid.test(invalidElementIndex)) {
                    swap.swap(invalidElementIndex, validElementCount);
                    ++validElementCount;
                    continue block0;
                }
                invalidElementIndex = arraySize - ++invalidElementCount;
            }
        }
        return validElementCount;
    }

    public static <T> Stream<T> listReverseStream(final List<T> list) {
        return Streams.stream((Iterator)new Iterator<T>(){
            int index;
            {
                this.index = list.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public T next() {
                int i = this.index--;
                return list.get(i);
            }
        });
    }

    public static Event<Runnable> createRunnableEvent() {
        return EventFactory.createArrayBacked(Runnable.class, listeners -> () -> {
            for (Runnable listener : listeners) {
                listener.run();
            }
        });
    }

    public static <T> Event<Consumer<T>> createConsumerEvent() {
        return EventFactory.createArrayBacked(Consumer.class, listeners -> t -> {
            for (Consumer listener : listeners) {
                listener.accept(t);
            }
        });
    }

    public static <A, B> Event<BiConsumer<A, B>> createBiConsumerEvent() {
        return EventFactory.createArrayBacked(BiConsumer.class, listeners -> (a, b) -> {
            for (BiConsumer listener : listeners) {
                listener.accept(a, b);
            }
        });
    }

    public static class_2499 vec3ToListTag(class_243 vec) {
        class_2499 listTag = new class_2499();
        listTag.add((Object)class_2489.method_23241((double)vec.field_1352));
        listTag.add((Object)class_2489.method_23241((double)vec.field_1351));
        listTag.add((Object)class_2489.method_23241((double)vec.field_1350));
        return listTag;
    }

    @Nullable
    public static class_243 vec3FromListTag(class_2520 tag) {
        class_2499 listTag;
        if (tag instanceof class_2499 && (listTag = (class_2499)tag).method_10601() == 6 && listTag.size() == 3) {
            return new class_243(listTag.method_10611(0), listTag.method_10611(1), listTag.method_10611(2));
        }
        return null;
    }

    public static class_238 boundingBoxOfPoints(class_243[] arr) {
        Validate.isTrue((arr.length != 0 ? 1 : 0) != 0, (String)"arr must not be empty", (Object[])new Object[0]);
        double minX = arr[0].field_1352;
        double minY = arr[0].field_1351;
        double minZ = arr[0].field_1350;
        double maxX = arr[0].field_1352;
        double maxY = arr[0].field_1351;
        double maxZ = arr[0].field_1350;
        for (int i = 1; i < arr.length; ++i) {
            class_243 vec3 = arr[i];
            minX = Math.min(minX, vec3.field_1352);
            minY = Math.min(minY, vec3.field_1351);
            minZ = Math.min(minZ, vec3.field_1350);
            maxX = Math.max(maxX, vec3.field_1352);
            maxY = Math.max(maxY, vec3.field_1351);
            maxZ = Math.max(maxZ, vec3.field_1350);
        }
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static class SimpleBox<T> {
        public T obj;

        public SimpleBox(T obj) {
            this.obj = obj;
        }
    }

    public static interface IntObjectConsumer<T> {
        public void consume(int var1, T var2);
    }

    public static interface BoxEdgeConsumer {
        public void consume(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    @FunctionalInterface
    public static interface SwappingFunc {
        public void swap(int var1, int var2);
    }
}

